/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.File;
import java.io.IOException;

public class DirEntry {
    public static final byte BITMASK_FILETYPE = 7;
    public static final byte FILETYPE_NONE = -1;
    public static final byte FILETYPE_DEL = 0;
    public static final byte FILETYPE_SEQ = 1;
    public static final byte FILETYPE_PRG = 2;
    public static final byte FILETYPE_USR = 3;
    public static final byte FILETYPE_REL = 4;
    private static final String[] FILETYPES = new String[]{"DEL", "SEQ", "PRG", "USR", "REL"};
    private int blocks;
    private byte[] filename;
    private byte fileType;

    public DirEntry(int nrSectors, byte[] fn, byte fType) {
        this.blocks = nrSectors;
        this.filename = fn;
        this.fileType = fType;
    }

    public static final String toQuotedFilenameAndType(byte[] fileName, byte fileType) {
        byte c;
        StringBuffer fn = new StringBuffer();
        fn.append("\"");
        int end = -1;
        for (int i = 0; i < fileName.length && (c = fileName[i]) != 13 && c != 0; ++i) {
            if (c == -96 && i + 1 < fileName.length && fileName[i + 1] != -96) {
                end = i;
            }
            fn.append((char)(c & 0xFF));
        }
        if (end != -1) {
            fn.setCharAt(end + 1, '\"');
        } else {
            fn.append("\"");
        }
        if (fileType != -1) {
            int ft = fileType & 7;
            if (ft < FILETYPES.length) {
                fn.append(" ").append(FILETYPES[ft - 0]);
            } else {
                fn.append(" ").append("???");
            }
        }
        return fn.toString();
    }

    public static final String toFilename(String directoryLine) {
        String[] parts = directoryLine.split("\"");
        if (parts.length < 2) {
            return "*";
        }
        return parts[1];
    }

    public String getDirectoryLine() {
        return String.format("%-3d  %s", this.blocks, DirEntry.toQuotedFilenameAndType(this.filename, this.fileType));
    }

    @JsonIgnore
    public final String getValidFilename() {
        String convertFilename = DirEntry.toQuotedFilenameAndType(this.filename, (byte)-1);
        return convertFilename.substring(1, convertFilename.length() - 1).replace('/', '_');
    }

    public void save(File autostartFile) throws IOException {
    }
}

